/*
 * Decompiled with CFR 0.152.
 */
package org.jb2011.lnf.beautyeye.ch17_split;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.jb2011.lnf.beautyeye.ch17_split.__Icon9Factory__;
import org.jb2011.lnf.beautyeye.utils.BEUtils;
import sun.swing.DefaultLookup;

public class BESplitPaneDivider
extends BasicSplitPaneDivider {
    private int oneTouchSize;
    protected final Color TOUCH_BUTTON_COLOR = new Color(58, 135, 173);
    protected static final int TOUCH_DECRATED_BUTTON_W = 5;
    protected static final int TOUCH_DECRATED_BUTTON_H = 30;
    protected static final Color TOUCH_DECRATED_BUTTON_COLOR = new Color(180, 180, 180);
    protected static final Color TOUCH_DECRATED_BUTTON_HILIGHT_COLOR = Color.white;

    public BESplitPaneDivider(BasicSplitPaneUI ui) {
        super(ui);
        this.oneTouchSize = DefaultLookup.getInt(ui.getSplitPane(), ui, "SplitPane.oneTouchButtonSize", 6);
    }

    public void paint(Graphics g) {
        Color bgColor = this.splitPane.hasFocus() ? UIManager.getColor("SplitPane.shadow") : this.getBackground();
        Dimension size = this.getSize();
        Graphics2D g2 = (Graphics2D)g;
        BEUtils.setAntiAliasing((Graphics2D)g, true);
        if (bgColor != null) {
            int orient = this.splitPane.getOrientation();
            if (orient == 1) {
                int halfWidth = size.width / 2;
                int halfHeight = size.height / 2;
                Stroke oldStroke = ((Graphics2D)g).getStroke();
                BasicStroke sroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 0.0f);
                ((Graphics2D)g).setStroke(sroke);
                g.setColor(TOUCH_DECRATED_BUTTON_COLOR);
                g.drawLine(halfWidth + 0, 0, halfWidth + 0, size.height);
                g.setColor(TOUCH_DECRATED_BUTTON_HILIGHT_COLOR);
                g.drawLine(halfWidth + 1, 0, halfWidth + 1, size.height);
                ((Graphics2D)g).setStroke(oldStroke);
                int decratedButton_w = 5;
                int decratedButton_h = 30;
                int diverTouchStartX = halfWidth - decratedButton_w / 2;
                __Icon9Factory__.getInstance().getSplitTouchBg1().draw((Graphics2D)g, diverTouchStartX, halfHeight - decratedButton_h / 2, decratedButton_w, decratedButton_h);
            } else {
                int halfHeight = size.height / 2;
                int halfWidth = size.width / 2;
                Stroke oldStroke = ((Graphics2D)g).getStroke();
                BasicStroke sroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 0.0f);
                ((Graphics2D)g).setStroke(sroke);
                g.setColor(TOUCH_DECRATED_BUTTON_COLOR);
                g.drawLine(0, halfHeight + 0, size.width, halfHeight + 0);
                g.setColor(TOUCH_DECRATED_BUTTON_HILIGHT_COLOR);
                g.drawLine(0, halfHeight + 1, size.width, halfHeight + 1);
                ((Graphics2D)g).setStroke(oldStroke);
                int decratedButton_w = 5;
                int decratedButton_h = 30;
                int diverTouchStartY = halfHeight - decratedButton_w / 2;
                __Icon9Factory__.getInstance().getSplitTouchBg1().draw((Graphics2D)g, halfWidth - decratedButton_h, diverTouchStartY, decratedButton_h, decratedButton_w);
            }
            BEUtils.setAntiAliasing((Graphics2D)g, false);
        }
        super.paint(g);
    }

    protected JButton createLeftOneTouchButton() {
        JButton b = new JButton(){

            public void setBorder(Border b) {
            }

            public void paint(Graphics g) {
                if (BESplitPaneDivider.this.splitPane != null) {
                    int[] xs = new int[3];
                    int[] ys = new int[3];
                    g.setColor(this.getBackground());
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g.setColor(BESplitPaneDivider.this.TOUCH_BUTTON_COLOR);
                    BEUtils.setAntiAliasing((Graphics2D)g, true);
                    if (BESplitPaneDivider.this.orientation == 0) {
                        int blockSize;
                        xs[0] = blockSize = Math.min(this.getHeight(), BESplitPaneDivider.this.oneTouchSize);
                        xs[1] = 0;
                        xs[2] = blockSize << 1;
                        ys[0] = 0;
                        ys[1] = ys[2] = blockSize;
                        g.drawPolygon(xs, ys, 3);
                    } else {
                        int blockSize;
                        xs[0] = xs[2] = (blockSize = Math.min(this.getWidth(), BESplitPaneDivider.this.oneTouchSize));
                        xs[1] = 0;
                        ys[0] = 0;
                        ys[1] = blockSize;
                        ys[2] = blockSize << 1;
                    }
                    g.fillPolygon(xs, ys, 3);
                    BEUtils.setAntiAliasing((Graphics2D)g, false);
                }
            }

            public boolean isFocusTraversable() {
                return false;
            }
        };
        b.setMinimumSize(new Dimension(this.oneTouchSize, this.oneTouchSize));
        b.setCursor(Cursor.getPredefinedCursor(0));
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setRequestFocusEnabled(false);
        return b;
    }

    protected JButton createRightOneTouchButton() {
        JButton b = new JButton(){

            public void setBorder(Border border) {
            }

            public void paint(Graphics g) {
                if (BESplitPaneDivider.this.splitPane != null) {
                    int[] xs = new int[3];
                    int[] ys = new int[3];
                    g.setColor(this.getBackground());
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    BEUtils.setAntiAliasing((Graphics2D)g, true);
                    if (BESplitPaneDivider.this.orientation == 0) {
                        int blockSize;
                        xs[0] = blockSize = Math.min(this.getHeight(), BESplitPaneDivider.this.oneTouchSize);
                        xs[1] = blockSize << 1;
                        xs[2] = 0;
                        ys[0] = blockSize;
                        ys[2] = 0;
                        ys[1] = 0;
                    } else {
                        int blockSize = Math.min(this.getWidth(), BESplitPaneDivider.this.oneTouchSize);
                        xs[2] = 0;
                        xs[0] = 0;
                        xs[1] = blockSize;
                        ys[0] = 0;
                        ys[1] = blockSize;
                        ys[2] = blockSize << 1;
                    }
                    g.setColor(BESplitPaneDivider.this.TOUCH_BUTTON_COLOR);
                    g.fillPolygon(xs, ys, 3);
                    BEUtils.setAntiAliasing((Graphics2D)g, false);
                }
            }

            public boolean isFocusTraversable() {
                return false;
            }
        };
        b.setMinimumSize(new Dimension(this.oneTouchSize, this.oneTouchSize));
        b.setCursor(Cursor.getPredefinedCursor(0));
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setRequestFocusEnabled(false);
        return b;
    }
}

