/*
 * Decompiled with CFR 0.152.
 */
package com.daniel.apps.handtrackServer.utils;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class IpGetter {
    public static List<String> Interfaces = new ArrayList<String>();

    public static String getIpAddr(String type) {
        try {
            Enumeration<NetworkInterface> n = NetworkInterface.getNetworkInterfaces();
            while (n.hasMoreElements()) {
                NetworkInterface e = n.nextElement();
                if (!e.getName().startsWith(type) && !e.getName().startsWith("en")) continue;
                Enumeration<InetAddress> a = e.getInetAddresses();
                while (a.hasMoreElements()) {
                    InetAddress addr = a.nextElement();
                    if (!(addr instanceof Inet4Address)) continue;
                    return addr.getHostAddress();
                }
            }
            if (!type.equals("eth")) {
                return IpGetter.getIpAddr("eth");
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return "Make sure WiFi is turned on";
    }

    public static List<String> getAllWlanIpAddrs() {
        Interfaces.clear();
        try {
            Enumeration<NetworkInterface> n = NetworkInterface.getNetworkInterfaces();
            while (n.hasMoreElements()) {
                NetworkInterface e = n.nextElement();
                Enumeration<InetAddress> a = e.getInetAddresses();
                while (a.hasMoreElements()) {
                    InetAddress addr = a.nextElement();
                    String address = addr.getHostAddress();
                    if (address.contains(":") || Integer.parseInt(address.substring(0, 3)) == 127) continue;
                    Interfaces.add(String.valueOf(e.getName()) + ": " + address);
                }
            }
            return Interfaces;
        }
        catch (SocketException e1) {
            e1.printStackTrace();
            Interfaces.add("Make sure WiFi is turned on");
            return Interfaces;
        }
    }
}

