/*
 * Decompiled with CFR 0.152.
 */
package com.daniel.apps.handtrackServer.ui;

import com.daniel.apps.handtrackServer.connection.SimpleSPPServer;
import com.daniel.apps.handtrackServer.connection.SocketServer;
import com.daniel.apps.handtrackServer.ui.ActionListener;
import com.daniel.apps.handtrackServer.utils.IpGetter;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextPane;

public class UIController {
    private State state;
    private Mode mode;
    private static SocketServer server;
    private static JButton startButton;
    private static JLabel connectionInfoLabel;
    private static JLabel location;
    boolean isConnected = false;
    private static SimpleSPPServer BTserver;

    public UIController(JButton startButton, JLabel connectionInfo, JLabel location) {
        server = new SocketServer();
        BTserver = new SimpleSPPServer();
        server.setActionListener(new ActionListener(this));
        BTserver.setActionListener(new ActionListener(this));
        this.state = State.IDLE;
        this.mode = Mode.BT;
        UIController.startButton = startButton;
        connectionInfoLabel = connectionInfo;
        UIController.location = location;
    }

    public UIController() {
        this(startButton, connectionInfoLabel, location);
    }

    public void updateValues(int x, int y) {
        location.setText("Mouse position X:  " + x + "    Y:  " + y);
    }

    public void processEvent(String actionCommand) {
        switch (actionCommand) {
            case "start": {
                if (this.mode == Mode.WIFI) {
                    if (this.state == State.IDLE) {
                        server.start();
                        this.state = State.STARTED;
                        startButton.setText("Stop ");
                        break;
                    }
                    server.stop();
                    this.state = State.IDLE;
                    startButton.setText("Start");
                    break;
                }
                if (this.state == State.IDLE) {
                    startButton.setText("Stop");
                    BTserver.Start();
                    this.state = State.STARTED;
                    break;
                }
                this.state = State.IDLE;
                startButton.setText("Start");
                BTserver.stopServer();
                break;
            }
            case "connected": {
                connectionInfoLabel.setText("Connected!");
                this.isConnected = true;
                break;
            }
            case "disconnected": {
                connectionInfoLabel.setText("Disconnected!");
                this.isConnected = false;
                break;
            }
            case "bt": {
                this.mode = Mode.BT;
                this.state = State.IDLE;
                startButton.setText("Start");
                server.stop();
                break;
            }
            case "wifi": {
                this.mode = Mode.WIFI;
                this.state = State.IDLE;
                startButton.setText("Start");
                try {
                    BTserver.stopServer();
                }
                catch (Exception exception) {}
                break;
            }
            case "moreIPs": {
                this.showMoreDialog();
                break;
            }
            default: {
                System.err.println("Unknown action command: " + actionCommand);
            }
        }
    }

    private void showMoreDialog() {
        JFrame mainFrame = new JFrame("More IP Info");
        mainFrame.setSize(300, 225);
        mainFrame.setResizable(true);
        JTextPane info = new JTextPane();
        info.setEditable(false);
        Object[] t = IpGetter.getAllWlanIpAddrs().toArray();
        String infoText = "";
        Object[] objectArray = t;
        int n = t.length;
        int n2 = 0;
        while (n2 < n) {
            Object inf = objectArray[n2];
            infoText = String.valueOf(infoText) + inf.toString() + " \n";
            ++n2;
        }
        info.setText(infoText);
        mainFrame.add(info);
        mainFrame.setVisible(true);
    }

    private static enum Mode {
        BT,
        WIFI;

    }

    private static enum State {
        IDLE,
        STARTED;

    }
}

