/*
 * Decompiled with CFR 0.152.
 */
package com.daniel.apps.handtrackServer.ui;

import com.daniel.apps.handtrackServer.ui.ActionListener;
import com.daniel.apps.handtrackServer.ui.UIController;
import com.daniel.apps.handtrackServer.utils.IpGetter;
import com.daniel.apps.handtrackServer.utils.MacGetter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import org.jb2011.lnf.beautyeye.BeautyEyeLNFHelper;

public class MainWindow {
    private UIController controller;

    public MainWindow() {
        try {
            BeautyEyeLNFHelper.launchBeautyEyeLNF();
            UIManager.put("RootPane.setupButtonVisible", false);
            BeautyEyeLNFHelper.frameBorderStyle = BeautyEyeLNFHelper.FrameBorderStyle.osLookAndFeelDecorated;
            BeautyEyeLNFHelper.translucencyAtFrameInactive = true;
        }
        catch (Exception e) {
            System.out.println("error seting theme");
        }
        final JFrame mainFrame = new JFrame("HandTrack PC Receiver");
        mainFrame.setSize(500, 225);
        mainFrame.setDefaultCloseOperation(3);
        mainFrame.setResizable(true);
        mainFrame.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("logo.png")));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BorderLayout());
        JButton startButton = new JButton("Start");
        JLabel connectionInfo = new JLabel("Disconnected!");
        connectionInfo.setFont(new Font("Roboto", 0, 13));
        connectionInfo.setBackground(Color.WHITE);
        connectionInfo.setHorizontalAlignment(0);
        JLabel location = new JLabel("X: 0 Y: 0");
        location.setFont(new Font("Roboto", 0, 11));
        location.setHorizontalAlignment(0);
        this.controller = new UIController(startButton, connectionInfo, location);
        final ActionListener buttonListener = new ActionListener(this.controller);
        new Thread(new Runnable(){

            @Override
            public void run() {
                JPanel info = new JPanel(new BorderLayout());
                JLabel ipLabel = new JLabel("<html> IP address: " + IpGetter.getIpAddr("wlan") + " <br/> MAC address: " + MacGetter.getBTAddress() + "</html>");
                ipLabel.setFont(new Font("Roboto", 1, 14));
                ipLabel.setHorizontalAlignment(0);
                JButton moreIPs = new JButton("+");
                moreIPs.setFont(new Font("Roboto", 1, 35));
                moreIPs.setForeground(Color.gray);
                moreIPs.setMargin(new Insets(0, 0, 0, 10));
                moreIPs.addActionListener(buttonListener);
                moreIPs.setActionCommand("moreIPs");
                moreIPs.setOpaque(false);
                moreIPs.setContentAreaFilled(false);
                moreIPs.setBorderPainted(false);
                moreIPs.setFocusable(false);
                info.add((Component)ipLabel, "West");
                info.add((Component)moreIPs, "East");
                mainFrame.add((Component)info, "North");
                mainFrame.validate();
            }
        }).start();
        startButton.setFont(new Font("Roboto", 0, 20));
        startButton.setActionCommand("start");
        startButton.setBackground(Color.WHITE);
        startButton.setForeground(Color.DARK_GRAY);
        startButton.addActionListener(buttonListener);
        JRadioButton bt = new JRadioButton("Bluetooth");
        bt.setActionCommand("bt");
        bt.addActionListener(buttonListener);
        bt.setSelected(true);
        JRadioButton wifi = new JRadioButton("WiFi / Ethernet");
        wifi.setActionCommand("wifi");
        wifi.addActionListener(buttonListener);
        ButtonGroup group = new ButtonGroup();
        group.add(bt);
        group.add(wifi);
        JPanel radioPanel = new JPanel(new GridLayout(1, 0));
        radioPanel.add(bt);
        radioPanel.add(wifi);
        buttonPanel.add((Component)radioPanel, "North");
        buttonPanel.add((Component)connectionInfo, "South");
        buttonPanel.add((Component)startButton, "Center");
        mainFrame.add((Component)buttonPanel, "Center");
        mainFrame.add((Component)location, "South");
        mainFrame.setVisible(true);
    }
}

