/*
 * Decompiled with CFR 0.152.
 */
package com.daniel.apps.handtrackServer.connection;

import com.daniel.apps.handtrackServer.controller.RobotController;
import com.daniel.apps.handtrackServer.utils.Controller;

public class MessageDecoder {
    static final String MOUSE_LEFT_BTN_DOWN = "LD";
    static final String MOUSE_LEFT_BTN_UP = "LU";
    static final String MOUSE_RIGHT_BTN_DOWN = "RD";
    static final String MOUSE_RIGHT_BTN_UP = "RU";
    static final String MOUSE_MIDDLE_BTN_DOWN = "MD";
    static final String MOUSE_MIDDLE_BTN_UP = "MU";
    static final String MOUSE_LEFT_CLICK = "LC";
    static final String LOCATION = "XY";
    static final String ROTATE = "RT";
    static final String ROTATE_STOP = "R0";
    static final String CURSOR_START = "C1";
    static final String CURSOR_STOP = "C2";
    static final String SCROLL = "SC";
    private Controller controller = new RobotController();

    public void decode(String message) throws Exception {
        String[] pairs = message.split("_");
        switch (pairs[0]) {
            case "XY": {
                this.controller.orient(Double.parseDouble(pairs[1]), Double.parseDouble(pairs[2]));
                break;
            }
            case "LD": {
                this.controller.clickLeftDown();
                break;
            }
            case "LU": {
                this.controller.clickLeftUp();
                break;
            }
            case "RD": {
                this.controller.clickRightDown();
                break;
            }
            case "RU": {
                this.controller.clickRightUp();
                break;
            }
            case "LC": {
                this.controller.clickLeft();
                break;
            }
            case "SC": {
                this.controller.down(Integer.parseInt(pairs[1]));
                break;
            }
            default: {
                System.err.println("Unknown message: " + message);
            }
        }
    }
}

