/*
 * Decompiled with CFR 0.152.
 */
package com.daniel.apps.handtrackServer.controller;

import com.daniel.apps.handtrackServer.ui.UIController;
import java.awt.AWTException;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.Robot;
import java.util.Timer;
import java.util.TimerTask;

public class MouseController {
    private Robot robot;
    private State state = State.IDLE;
    private Timer timer;
    double zero_x;
    double zero_y;
    int[] screenMatrix = new int[4];
    UIController ui = new UIController();

    public MouseController() {
        try {
            this.robot = new Robot();
            this.robot.setAutoDelay(0);
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
        this.zero_x = MouseInfo.getPointerInfo().getLocation().getX();
        this.zero_y = MouseInfo.getPointerInfo().getLocation().getY();
        this.detectScreenDimensions();
        this.timer = new Timer();
    }

    private static double clamp(double val, float min, float max) {
        return Math.max((double)min, Math.min((double)max, val));
    }

    public void detectScreenDimensions() {
        GraphicsDevice[] gd;
        GraphicsDevice[] graphicsDeviceArray = gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        int n = gd.length;
        int n2 = 0;
        while (n2 < n) {
            int dir;
            GraphicsDevice screen = graphicsDeviceArray[n2];
            Rectangle bounds = screen.getDefaultConfiguration().getBounds();
            int width = bounds.width - 1;
            int height = bounds.height - 1;
            int x = bounds.x;
            int y = bounds.y;
            int n3 = dir = Math.abs(x) > Math.abs(y) ? x : y;
            if (dir == x) {
                if (x >= 0) {
                    this.screenMatrix[0] = this.screenMatrix[0] + width;
                } else {
                    this.screenMatrix[1] = this.screenMatrix[1] + width;
                }
            }
            if (dir == y) {
                if (y >= 0) {
                    this.screenMatrix[2] = this.screenMatrix[2] + height;
                } else {
                    this.screenMatrix[3] = this.screenMatrix[3] + height;
                }
            }
            ++n2;
        }
    }

    public void moveRelative(double x, double y) {
        if (this.state == State.CLICKING) {
            return;
        }
        double tx = MouseController.clamp(x + this.zero_x, -this.screenMatrix[1], this.screenMatrix[0]);
        double ty = MouseController.clamp(y + this.zero_y, -this.screenMatrix[3], this.screenMatrix[2]);
        this.robot.mouseMove((int)tx, (int)ty);
        this.ui.updateValues((int)tx, (int)ty);
        this.zero_x = tx;
        this.zero_y = ty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clickLeft() {
        Robot robot = this.robot;
        synchronized (robot) {
            this.robot.mousePress(1024);
            try {
                Thread.sleep(20L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.robot.mouseRelease(1024);
        }
    }

    public void clickLeftDown() {
        this.robot.mousePress(1024);
        this.state = State.CLICKING;
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                MouseController.this.state = State.IDLE;
            }
        }, 100L);
    }

    public void clickLeftUp() {
        this.robot.mouseRelease(1024);
    }

    public void clickRightDown() {
        this.robot.mousePress(4096);
        this.state = State.CLICKING;
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                MouseController.this.state = State.IDLE;
            }
        }, 200L);
    }

    public void clickRightUp() {
        this.robot.mouseRelease(4096);
    }

    public void down(int amount) {
        this.robot.mouseWheel(amount);
    }

    private static enum State {
        IDLE,
        CLICKING;

    }
}

