/*
 * Decompiled with CFR 0.152.
 */
package com.daniel.apps.handtrackServer.connection;

import com.daniel.apps.handtrackServer.connection.MessageDecoder;
import com.daniel.apps.handtrackServer.ui.ActionListener;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;

public class SocketServer {
    private static ServerSocket serverSocket;
    private static Socket clientSocket;
    private static InputStreamReader inputStreamReader;
    private static BufferedReader bufferedReader;
    private String message;
    private boolean running;
    private ActionListener actionListener;

    public void start() {
        this.running = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                SocketServer.this.startInternal();
            }
        }).start();
    }

    public void stop() {
        try {
            this.running = false;
            if (serverSocket != null) {
                serverSocket.close();
            }
            if (clientSocket != null) {
                clientSocket.close();
            }
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void startInternal() {
        MessageDecoder decoder = new MessageDecoder();
        try {
            serverSocket = new ServerSocket(4445);
        }
        catch (IOException e) {
            System.out.println("Could not listen on port: 4445");
        }
        System.out.println("Server started. Listening to the port 4445");
        while (this.running) {
            try {
                clientSocket = serverSocket.accept();
                System.out.println("New client connected!");
                this.actionListener.actionPerformed(new ActionEvent(this, 0, "connected"));
                inputStreamReader = new InputStreamReader(clientSocket.getInputStream());
                bufferedReader = new BufferedReader(inputStreamReader);
                while (this.running) {
                    this.message = bufferedReader.readLine();
                    if (this.message == null) break;
                    decoder.decode(this.message);
                }
                inputStreamReader.close();
                clientSocket.close();
                this.actionListener.actionPerformed(new ActionEvent(this, 0, "disconnected"));
            }
            catch (Exception ex) {
                this.running = false;
            }
        }
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }
}

