/*
 * Decompiled with CFR 0.152.
 */
package org.bluez.v3;

import com.intel.bluetooth.BlueCoveImpl;
import com.intel.bluetooth.DebugLog;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.bluez.BlueZAPI;
import org.bluez.Error;
import org.bluez.v3.Adapter;
import org.bluez.v3.Database;
import org.bluez.v3.Manager;
import org.bluez.v3.PasskeyAgent;
import org.bluez.v3.Security;
import org.freedesktop.DBus;
import org.freedesktop.dbus.DBusConnection;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusSigHandler;
import org.freedesktop.dbus.DBusSignal;
import org.freedesktop.dbus.Path;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlueZAPIV3
implements BlueZAPI {
    private DBusConnection dbusConn;
    private Manager dbusManager;
    private Adapter adapter;
    private Path adapterPath;
    private long lastDeviceDiscoveryTime = 0L;

    public BlueZAPIV3(DBusConnection dbusConn, Manager dbusManager) {
        this.dbusConn = dbusConn;
        this.dbusManager = dbusManager;
    }

    @Override
    public Path findAdapter(String pattern) throws Error.InvalidArguments {
        String path;
        try {
            path = this.dbusManager.FindAdapter(pattern);
        }
        catch (Error.NoSuchAdapter e) {
            return null;
        }
        if (path == null) {
            return null;
        }
        return new Path(path);
    }

    @Override
    public Path defaultAdapter() throws Error.InvalidArguments {
        String path;
        try {
            path = this.dbusManager.DefaultAdapter();
        }
        catch (Error.NoSuchAdapter e) {
            return null;
        }
        if (path == null) {
            return null;
        }
        return new Path(path);
    }

    @Override
    public Path getAdapter(int number) {
        String[] adapters = this.dbusManager.ListAdapters();
        if (adapters == null) {
            throw null;
        }
        if (number < 0 || number >= adapters.length) {
            throw null;
        }
        return new Path(String.valueOf(adapters[number]));
    }

    @Override
    public List<String> listAdapters() {
        Vector<String> v = new Vector<String>();
        String[] adapters = this.dbusManager.ListAdapters();
        if (adapters != null) {
            for (int i = 0; i < adapters.length; ++i) {
                String adapterId = String.valueOf(adapters[i]);
                String bluezPath = "/org/bluez/";
                if (adapterId.startsWith("/org/bluez/")) {
                    adapterId = adapterId.substring("/org/bluez/".length());
                }
                v.add(adapterId);
            }
        }
        return v;
    }

    @Override
    public void selectAdapter(Path adapterPath) throws DBusException {
        DebugLog.debug("selectAdapter", adapterPath.getPath());
        this.adapter = (Adapter)this.dbusConn.getRemoteObject("org.bluez", adapterPath.getPath(), Adapter.class);
        this.adapterPath = adapterPath;
    }

    @Override
    public String getAdapterAddress() {
        return this.adapter.GetAddress();
    }

    @Override
    public String getAdapterID() {
        String bluezPath = "/org/bluez/";
        if (this.adapterPath.getPath().startsWith("/org/bluez/")) {
            return this.adapterPath.getPath().substring("/org/bluez/".length());
        }
        return this.adapterPath.getPath();
    }

    @Override
    public int getAdapterDeviceClass() {
        int record = 0;
        String major = this.adapter.GetMajorClass();
        if ("computer".equals(major)) {
            record |= 0x100;
        } else {
            DebugLog.debug("Unknown MajorClass", major);
        }
        String minor = this.adapter.GetMinorClass();
        if (minor.equals("uncategorized")) {
            record |= 0;
        } else if (minor.equals("desktop")) {
            record |= 4;
        } else if (minor.equals("server")) {
            record |= 8;
        } else if (minor.equals("laptop")) {
            record |= 0xC;
        } else if (minor.equals("handheld")) {
            record |= 0x10;
        } else if (minor.equals("palm")) {
            record |= 0x14;
        } else if (minor.equals("wearable")) {
            record |= 0x18;
        } else {
            DebugLog.debug("Unknown MinorClass", minor);
            record |= 0;
        }
        String[] srvc = this.adapter.GetServiceClasses();
        if (srvc != null) {
            for (int s = 0; s < srvc.length; ++s) {
                String serviceClass = srvc[s];
                if (serviceClass.equals("positioning")) {
                    record |= 0x10000;
                    continue;
                }
                if (serviceClass.equals("networking")) {
                    record |= 0x20000;
                    continue;
                }
                if (serviceClass.equals("rendering")) {
                    record |= 0x40000;
                    continue;
                }
                if (serviceClass.equals("capturing")) {
                    record |= 0x80000;
                    continue;
                }
                if (serviceClass.equals("object transfer")) {
                    record |= 0x100000;
                    continue;
                }
                if (serviceClass.equals("audio")) {
                    record |= 0x200000;
                    continue;
                }
                if (serviceClass.equals("telephony")) {
                    record |= 0x400000;
                    continue;
                }
                if (serviceClass.equals("information")) {
                    record |= 0x800000;
                    continue;
                }
                DebugLog.debug("Unknown ServiceClasses", serviceClass);
            }
        }
        return record;
    }

    @Override
    public String getAdapterName() {
        try {
            return this.adapter.GetName();
        }
        catch (Error.NotReady e) {
            return null;
        }
        catch (Error.Failed e) {
            return null;
        }
    }

    @Override
    public boolean isAdapterDiscoverable() {
        return this.adapter.IsDiscoverable();
    }

    @Override
    public int getAdapterDiscoverableTimeout() {
        return this.adapter.GetDiscoverableTimeout().intValue();
    }

    @Override
    public boolean setAdapterDiscoverable(int mode) throws DBusException {
        String modeStr;
        switch (mode) {
            case 0: {
                modeStr = "connectable";
                break;
            }
            case 10390323: {
                modeStr = "discoverable";
                break;
            }
            case 10390272: {
                modeStr = "limited";
                break;
            }
            default: {
                if (10390272 <= mode && mode <= 10390335) {
                    return false;
                }
                throw new IllegalArgumentException("Invalid discoverable mode");
            }
        }
        this.adapter.SetMode(modeStr);
        return true;
    }

    @Override
    public String getAdapterManufacturer() {
        return this.adapter.GetManufacturer();
    }

    @Override
    public String getAdapterRevision() {
        return this.adapter.GetRevision();
    }

    @Override
    public String getAdapterVersion() {
        return this.adapter.GetVersion();
    }

    @Override
    public boolean isAdapterPowerOn() {
        return !"off".equals(this.adapter.GetMode());
    }

    private <T extends DBusSignal> void quietRemoveSigHandler(Class<T> type, DBusSigHandler<T> handler) {
        try {
            this.dbusConn.removeSigHandler(type, handler);
        }
        catch (DBusException dBusException) {
            // empty catch block
        }
    }

    private boolean hasBonding(String deviceAddress) {
        try {
            return this.adapter.HasBonding(deviceAddress);
        }
        catch (Throwable e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deviceInquiry(final BlueZAPI.DeviceInquiryListener listener) throws DBusException, InterruptedException {
        final Object discoveryCompletedEvent = new Object();
        DBusSigHandler<Adapter.DiscoveryCompleted> discoveryCompleted = new DBusSigHandler<Adapter.DiscoveryCompleted>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(Adapter.DiscoveryCompleted s) {
                DebugLog.debug("discoveryCompleted.handle()");
                Object object = discoveryCompletedEvent;
                synchronized (object) {
                    discoveryCompletedEvent.notifyAll();
                }
            }
        };
        DBusSigHandler<Adapter.DiscoveryStarted> discoveryStarted = new DBusSigHandler<Adapter.DiscoveryStarted>(){

            public void handle(Adapter.DiscoveryStarted s) {
                DebugLog.debug("device discovery procedure has been started.");
            }
        };
        DBusSigHandler<Adapter.RemoteDeviceFound> remoteDeviceFound = new DBusSigHandler<Adapter.RemoteDeviceFound>(){

            public void handle(Adapter.RemoteDeviceFound s) {
                listener.deviceDiscovered(s.getDeviceAddress(), null, s.getDeviceClass().intValue(), BlueZAPIV3.this.hasBonding(s.getDeviceAddress()));
            }
        };
        DBusSigHandler<Adapter.RemoteNameUpdated> remoteNameUpdated = new DBusSigHandler<Adapter.RemoteNameUpdated>(){

            public void handle(Adapter.RemoteNameUpdated s) {
                listener.deviceDiscovered(s.getDeviceAddress(), s.getDeviceName(), -1, false);
            }
        };
        DBusSigHandler<Adapter.RemoteClassUpdated> remoteClassUpdated = new DBusSigHandler<Adapter.RemoteClassUpdated>(){

            public void handle(Adapter.RemoteClassUpdated s) {
                listener.deviceDiscovered(s.getDeviceAddress(), null, s.getDeviceClass().intValue(), BlueZAPIV3.this.hasBonding(s.getDeviceAddress()));
            }
        };
        try {
            this.dbusConn.addSigHandler(Adapter.DiscoveryCompleted.class, (DBusSigHandler)discoveryCompleted);
            this.dbusConn.addSigHandler(Adapter.DiscoveryStarted.class, (DBusSigHandler)discoveryStarted);
            this.dbusConn.addSigHandler(Adapter.RemoteDeviceFound.class, (DBusSigHandler)remoteDeviceFound);
            this.dbusConn.addSigHandler(Adapter.RemoteNameUpdated.class, (DBusSigHandler)remoteNameUpdated);
            this.dbusConn.addSigHandler(Adapter.RemoteClassUpdated.class, (DBusSigHandler)remoteClassUpdated);
            long sinceDiscoveryLast = System.currentTimeMillis() - this.lastDeviceDiscoveryTime;
            long acceptableInterval = 5000L;
            if (sinceDiscoveryLast < acceptableInterval) {
                Thread.sleep(acceptableInterval - sinceDiscoveryLast);
            }
            Object object = discoveryCompletedEvent;
            synchronized (object) {
                this.adapter.DiscoverDevices();
                listener.deviceInquiryStarted();
                DebugLog.debug("wait for device inquiry to complete...");
                discoveryCompletedEvent.wait();
            }
        }
        finally {
            this.quietRemoveSigHandler(Adapter.RemoteClassUpdated.class, remoteClassUpdated);
            this.quietRemoveSigHandler(Adapter.RemoteNameUpdated.class, remoteNameUpdated);
            this.quietRemoveSigHandler(Adapter.RemoteDeviceFound.class, remoteDeviceFound);
            this.quietRemoveSigHandler(Adapter.DiscoveryStarted.class, discoveryStarted);
            this.quietRemoveSigHandler(Adapter.DiscoveryCompleted.class, discoveryCompleted);
        }
    }

    @Override
    public void deviceInquiryCancel() throws DBusException {
        this.adapter.CancelDiscovery();
    }

    @Override
    public String getRemoteDeviceFriendlyName(final String deviceAddress) throws DBusException, IOException {
        final Object discoveryCompletedEvent = new Object();
        final Vector namesFound = new Vector();
        DBusSigHandler<Adapter.DiscoveryCompleted> discoveryCompleted = new DBusSigHandler<Adapter.DiscoveryCompleted>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(Adapter.DiscoveryCompleted s) {
                DebugLog.debug("discoveryCompleted.handle()");
                Object object = discoveryCompletedEvent;
                synchronized (object) {
                    discoveryCompletedEvent.notifyAll();
                }
            }
        };
        DBusSigHandler<Adapter.RemoteNameUpdated> remoteNameUpdated = new DBusSigHandler<Adapter.RemoteNameUpdated>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(Adapter.RemoteNameUpdated s) {
                if (deviceAddress.equals(s.getDeviceAddress())) {
                    if (s.getDeviceName() != null) {
                        namesFound.add(s.getDeviceName());
                        Object object = discoveryCompletedEvent;
                        synchronized (object) {
                            discoveryCompletedEvent.notifyAll();
                        }
                    } else {
                        DebugLog.debug("device name is null");
                    }
                } else {
                    DebugLog.debug("ignore device name " + s.getDeviceAddress() + " " + s.getDeviceName());
                }
            }
        };
        try {
            this.dbusConn.addSigHandler(Adapter.DiscoveryCompleted.class, (DBusSigHandler)discoveryCompleted);
            this.dbusConn.addSigHandler(Adapter.RemoteNameUpdated.class, (DBusSigHandler)remoteNameUpdated);
            Object object = discoveryCompletedEvent;
            synchronized (object) {
                this.adapter.DiscoverDevices();
                DebugLog.debug("wait for device inquiry to complete...");
                try {
                    discoveryCompletedEvent.wait();
                    DebugLog.debug(namesFound.size() + " device name(s) found");
                    if (namesFound.size() == 0) {
                        throw new IOException("Can't retrive device name");
                    }
                    String string = (String)namesFound.get(namesFound.size() - 1);
                    return string;
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            }
        }
        finally {
            this.quietRemoveSigHandler(Adapter.RemoteNameUpdated.class, remoteNameUpdated);
            this.quietRemoveSigHandler(Adapter.DiscoveryCompleted.class, discoveryCompleted);
        }
    }

    @Override
    public List<String> retrieveDevices(boolean preKnown) {
        String[] trusted;
        if (!preKnown) {
            return null;
        }
        Vector<String> addresses = new Vector<String>();
        String[] bonded = this.adapter.ListBondings();
        if (bonded != null) {
            for (int i = 0; i < bonded.length; ++i) {
                addresses.add(bonded[i]);
            }
        }
        if ((trusted = this.adapter.ListTrusts()) != null) {
            for (int i = 0; i < trusted.length; ++i) {
                addresses.add(trusted[i]);
            }
        }
        return addresses;
    }

    @Override
    public boolean isRemoteDeviceConnected(String deviceAddress) throws DBusException {
        return this.adapter.IsConnected(deviceAddress);
    }

    @Override
    public Boolean isRemoteDeviceTrusted(String deviceAddress) throws DBusException {
        return this.adapter.HasBonding(deviceAddress);
    }

    @Override
    public void authenticateRemoteDevice(String deviceAddress) throws DBusException {
        this.adapter.CreateBonding(deviceAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean authenticateRemoteDevice(final String deviceAddress, final String passkey) throws DBusException {
        if (passkey == null) {
            this.authenticateRemoteDevice(deviceAddress);
            return true;
        }
        PasskeyAgent passkeyAgent = new PasskeyAgent(){

            public String Request(String path, String address) throws Error.Rejected, Error.Canceled {
                if (deviceAddress.equals(address)) {
                    DebugLog.debug("PasskeyAgent.Request");
                    return passkey;
                }
                return "";
            }

            public boolean isRemote() {
                return false;
            }

            public void Cancel(String path, String address) {
            }

            public void Release() {
            }
        };
        DebugLog.debug("get security on path", this.adapterPath.getPath());
        Security security = (Security)this.dbusConn.getRemoteObject("org.bluez", this.adapterPath.getPath(), Security.class);
        String passkeyAgentPath = "/org/bluecove/authenticate/" + this.getAdapterID() + "/" + deviceAddress.replace(':', '_');
        DebugLog.debug("export passkeyAgent", passkeyAgentPath);
        this.dbusConn.exportObject(passkeyAgentPath, (DBusInterface)passkeyAgent);
        boolean useDefaultPasskeyAgentBug = BlueCoveImpl.getConfigProperty("bluecove.bluez.registerDefaultPasskeyAgent", false);
        try {
            if (useDefaultPasskeyAgentBug) {
                security.RegisterDefaultPasskeyAgent(passkeyAgentPath);
            } else {
                security.RegisterPasskeyAgent(passkeyAgentPath, deviceAddress);
            }
            this.adapter.CreateBonding(deviceAddress);
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                if (useDefaultPasskeyAgentBug) {
                    security.UnregisterDefaultPasskeyAgent(passkeyAgentPath);
                } else {
                    security.UnregisterPasskeyAgent(passkeyAgentPath, deviceAddress);
                }
            }
            catch (DBusExecutionException ignore) {}
            this.dbusConn.unExportObject(passkeyAgentPath);
        }
    }

    @Override
    public void removeAuthenticationWithRemoteDevice(String deviceAddress) throws DBusException {
        this.adapter.RemoveBonding(deviceAddress);
    }

    @Override
    public Map<Integer, String> getRemoteDeviceServices(String deviceAddress) throws DBusException {
        UInt32[] serviceHandles;
        String match = "";
        try {
            serviceHandles = this.adapter.GetRemoteServiceHandles(deviceAddress, match);
        }
        catch (DBus.Error.NoReply e) {
            return null;
        }
        if (serviceHandles == null) {
            throw new DBusException("Recived no records");
        }
        HashMap<Integer, String> xmlRecords = new HashMap<Integer, String>();
        for (int i = 0; i < serviceHandles.length; ++i) {
            xmlRecords.put(serviceHandles[i].intValue(), this.adapter.GetRemoteServiceRecordAsXML(deviceAddress, serviceHandles[i]));
        }
        return xmlRecords;
    }

    private Database getSDPService() throws DBusException {
        return (Database)this.dbusConn.getRemoteObject("org.bluez", "/org/bluez", Database.class);
    }

    @Override
    public long registerSDPRecord(String sdpXML) throws DBusException {
        DebugLog.debug("AddServiceRecordFromXML", sdpXML);
        UInt32 handle = this.getSDPService().AddServiceRecordFromXML(sdpXML);
        return handle.longValue();
    }

    @Override
    public void updateSDPRecord(long handle, String sdpXML) throws DBusException {
        DebugLog.debug("UpdateServiceRecordFromXML", sdpXML);
        this.getSDPService().UpdateServiceRecordFromXML(new UInt32(handle), sdpXML);
    }

    @Override
    public void unregisterSDPRecord(long handle) throws DBusException {
        DebugLog.debug("RemoveServiceRecord", handle);
        this.getSDPService().RemoveServiceRecord(new UInt32(handle));
    }
}

