/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.rmi;

import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.rmi.RemoteServiceImpl;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;

public class Server {
    static final int rmiRegistryPortDefault = 8090;
    static int rmiRegistryPort = 8090;
    private static Server server;
    private Registry registry = null;
    private Remote srv;

    public static void main(String[] args) {
        String port = null;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase("--port") || i >= args.length - 1) {
                if (args[i].equalsIgnoreCase("--help")) {
                    Server.help();
                    return;
                }
                Server.help();
                return;
            }
            port = args[++i];
        }
        if (port == null) {
            port = System.getProperty("bluecove.emu.rmiRegistryPort");
        }
        Server.start(port);
    }

    private static void help() {
        StringBuffer usage = new StringBuffer();
        usage.append("Usage:\n java ").append(Server.class.getName());
        usage.append("[--port rmiListeningPort]");
        System.out.println(usage);
    }

    public static void start(String port) {
        if (server != null) {
            return;
        }
        server = new Server();
        server.run(port);
    }

    private void run(String port) {
        this.startRMIRegistry(port);
        this.startRMIService();
        DebugLog.debug("Emulator RMI Service listening on port " + rmiRegistryPort);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void startRMIRegistry(String port) {
        try {
            if (port != null && port.length() > 0) {
                rmiRegistryPort = Integer.parseInt(port);
            }
            this.registry = LocateRegistry.createRegistry(rmiRegistryPort);
        }
        catch (RemoteException e) {
            throw new Error("Fails to start RMIRegistry", e);
        }
    }

    private void startRMIService() {
        try {
            this.srv = new RemoteServiceImpl();
            if (this.srv instanceof UnicastRemoteObject) {
                this.registry.rebind("BlueCoveRMIService", this.srv);
            } else {
                Remote stub = UnicastRemoteObject.exportObject(this.srv, 0);
                this.registry.rebind("BlueCoveRMIService", stub);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }
}

