/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.emu;

import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.RemoteDeviceHelper;
import com.intel.bluetooth.Utils;
import com.intel.bluetooth.emu.ConnectedInputStream;
import com.intel.bluetooth.emu.ConnectedOutputStream;
import com.intel.bluetooth.emu.ConnectionBuffer;
import com.intel.bluetooth.emu.ConnectionBufferL2CAP;
import com.intel.bluetooth.emu.ConnectionBufferRFCOMM;
import com.intel.bluetooth.emu.Device;
import com.intel.bluetooth.emu.DeviceManagerServiceImpl;
import com.intel.bluetooth.emu.MonitorConnection;
import com.intel.bluetooth.emu.MonitoringServiceImpl;
import java.io.IOException;
import java.io.InterruptedIOException;
import javax.bluetooth.BluetoothConnectionException;

class ServiceListener {
    private static final String RFCOMM_PREFIX = "rfcomm-";
    private static final String L2CAP_PREFIX = "l2cap-";
    private final String portID;
    private boolean rfcomm;
    private Object lock = new Object();
    private Device serverDevice;
    private static long connectionCount = 0L;
    private boolean connected = false;
    private boolean closed = false;
    private boolean interrupted = false;
    private long connectionId = 0L;
    private int serverSecurityOpt;
    private int serverReceiveMTU;

    static String rfPrefix(int channel) {
        return RFCOMM_PREFIX + channel;
    }

    static String l2Prefix(int pcm) {
        return L2CAP_PREFIX + Integer.toHexString(pcm);
    }

    ServiceListener(String portID) {
        this.portID = portID;
        this.rfcomm = this.portID.startsWith(RFCOMM_PREFIX);
    }

    String getPortID() {
        return this.portID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long accept(Device serverDevice, boolean authenticate, boolean encrypt, int serverReceiveMTU) throws IOException {
        this.serverDevice = serverDevice;
        this.serverReceiveMTU = serverReceiveMTU;
        this.serverSecurityOpt = Utils.securityOpt(authenticate, encrypt);
        serverDevice.serviceListenerAccepting(this.getPortID());
        while (!(this.closed || this.interrupted || this.connected)) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException("accept interrupted");
                }
            }
        }
        if (this.closed || this.interrupted || !this.connected) {
            throw new InterruptedIOException("accept closed");
        }
        return this.connectionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long connect(Device clientDevice, boolean authenticate, boolean encrypt, int cilentReceiveMTU, long timeout) throws IOException {
        ConnectionBuffer cb = null;
        boolean clientConnected = false;
        try {
            ConnectionBuffer sb;
            int securityOpt = Utils.securityOpt(authenticate, encrypt);
            if (this.serverSecurityOpt > securityOpt) {
                securityOpt = this.serverSecurityOpt;
            }
            int bsize = DeviceManagerServiceImpl.configuration.getConnectionBufferSize();
            boolean senderFlushBlock = DeviceManagerServiceImpl.configuration.isSenderFlushBlock();
            ConnectedInputStream cis = new ConnectedInputStream(bsize, senderFlushBlock);
            ConnectedOutputStream sos = new ConnectedOutputStream(cis);
            ConnectedInputStream sis = new ConnectedInputStream(bsize, senderFlushBlock);
            ConnectedOutputStream cos = new ConnectedOutputStream(sis);
            if (this.rfcomm) {
                cb = new ConnectionBufferRFCOMM(this.serverDevice.getDescriptor().getAddress(), this.getPortID(), cis, cos);
                sb = new ConnectionBufferRFCOMM(clientDevice.getDescriptor().getAddress(), this.getPortID(), sis, sos);
            } else {
                cb = new ConnectionBufferL2CAP(this.serverDevice.getDescriptor().getAddress(), this.getPortID(), cis, cos, this.serverReceiveMTU);
                sb = new ConnectionBufferL2CAP(clientDevice.getDescriptor().getAddress(), this.getPortID(), sis, sos, cilentReceiveMTU);
            }
            cb.connect(sb);
            cb.setSecurityOpt(securityOpt);
            sb.setSecurityOpt(securityOpt);
            sb.setServerSide(true);
            Class<ServiceListener> clazz = ServiceListener.class;
            synchronized (ServiceListener.class) {
                long id = ++connectionCount;
                // ** MonitorExit[var19_16] (shouldn't be in output)
                MonitorConnection monitor = new MonitorConnection(clientDevice.getDescriptor().getAddress(), this.serverDevice.getDescriptor().getAddress(), this.getPortID(), id);
                cb.setMonitor(monitor.getClientBuffer());
                sb.setMonitor(monitor.getServerBuffer());
                this.serverDevice.addConnectionBuffer(id, sb);
                this.connectionId = id;
                this.connected = true;
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
                long endOfDellay = System.currentTimeMillis() + timeout;
                while (!sb.isServerAccepted() && !sb.isClosed()) {
                    long timeleft = endOfDellay - System.currentTimeMillis();
                    if (timeleft <= 0L) {
                        throw new BluetoothConnectionException(5, "Service " + this.getPortID() + " not ready");
                    }
                    ConnectionBuffer connectionBuffer = sb;
                    synchronized (connectionBuffer) {
                        try {
                            sb.wait(timeleft);
                        }
                        catch (InterruptedException e) {
                            throw new InterruptedIOException();
                        }
                    }
                }
                if (!sb.isServerAccepted()) {
                    throw new BluetoothConnectionException(4, "Connection rejected");
                }
                MonitoringServiceImpl.registerConnection(monitor);
                clientDevice.addConnectionBuffer(id, cb);
                clientConnected = true;
                StringBuffer logMsg = new StringBuffer();
                logMsg.append(RemoteDeviceHelper.getBluetoothAddress(clientDevice.getDescriptor().getAddress()));
                logMsg.append(" connected to ");
                logMsg.append(RemoteDeviceHelper.getBluetoothAddress(this.serverDevice.getDescriptor().getAddress()));
                logMsg.append(" ").append(this.getPortID());
                DebugLog.debug(logMsg.toString());
                long l = id;
                return l;
            }
        }
        finally {
            if (!this.connected) {
                this.interrupted = true;
            }
            if (!clientConnected) {
                cb.close();
            }
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        this.closed = true;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }
}

