/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.emu;

import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.RemoteDeviceHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

public class EmulatorConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String CONFIG_FILE_NAME = "bluecove.emulator.properties";
    public static final String deviceName = "deviceName";
    public static final String deviceClass = "deviceClass";
    protected long firstDeviceAddress = 0xB1000000000L;
    protected String deviceNamePrefix = "EmuDevice";
    protected boolean deviceDiscoverable = true;
    protected int durationLIAC = 3;
    protected int deviceInquiryDuration = 11;
    protected boolean deviceInquiryRandomDelay = true;
    protected int connectionBufferSize = 8192;
    protected boolean linkEncryptionSupported = true;
    protected boolean senderFlushBlock = false;
    protected int keepAliveSeconds = 5;
    private Map<String, String> propertiesMap = new Hashtable<String, String>();

    public EmulatorConfiguration() {
        String TRUE = "true";
        String FALSE = "false";
        this.propertiesMap.put("bluetooth.connected.devices.max", "7");
        this.propertiesMap.put("bluetooth.sd.trans.max", "7");
        this.propertiesMap.put("bluetooth.connected.inquiry.scan", "true");
        this.propertiesMap.put("bluetooth.connected.page.scan", "true");
        this.propertiesMap.put("bluetooth.connected.inquiry", "true");
        this.propertiesMap.put("bluetooth.connected.page", "true");
        this.propertiesMap.put("bluetooth.sd.attr.retrievable.max", "255");
        this.propertiesMap.put("bluetooth.master.switch", "false");
        this.propertiesMap.put("bluetooth.l2cap.receiveMTU.max", "2048");
    }

    public void loadConfigFile() {
        String configName = System.getProperty(CONFIG_FILE_NAME, CONFIG_FILE_NAME);
        File file = new File(configName);
        if (file.exists()) {
            try {
                this.load(new FileInputStream(file));
            }
            catch (IOException e) {
                DebugLog.error("Error loading properties from file " + file.getAbsolutePath(), e);
            }
        } else {
            InputStream input;
            if (!configName.startsWith("/")) {
                configName = "/" + configName;
            }
            if ((input = this.getClass().getResourceAsStream(configName)) != null) {
                try {
                    this.load(input);
                }
                catch (IOException e) {
                    DebugLog.error("Error loading properties from resource " + configName, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(InputStream input) throws IOException {
        Properties values = new Properties();
        try {
            values.load(input);
        }
        finally {
            input.close();
        }
        for (Map.Entry<Object, Object> me : values.entrySet()) {
            String txt;
            Object value = me.getValue();
            if (value == null || (txt = value.toString().trim()).length() == 0) continue;
            this.propertiesMap.put(me.getKey().toString(), txt);
        }
        this.copyPertiesToFields();
    }

    private void copyPertiesToFields() {
        Field[] fields;
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            String value;
            if (Modifier.isStatic(field.getModifiers()) || (value = this.propertiesMap.get(field.getName())) == null) continue;
            Class<?> type = field.getType();
            try {
                if (String.class.isAssignableFrom(type)) {
                    field.set(this, value);
                    continue;
                }
                if (Boolean.TYPE.isAssignableFrom(type)) {
                    field.setBoolean(this, this.valueToBoolean(value));
                    continue;
                }
                if (Integer.TYPE.isAssignableFrom(type)) {
                    field.setInt(this, EmulatorConfiguration.valueToInt(value));
                    continue;
                }
                if (!Long.TYPE.isAssignableFrom(type)) continue;
                field.setLong(this, EmulatorConfiguration.valueToLong(value));
            }
            catch (Throwable e) {
                DebugLog.error("Error setting property " + field.getName(), e);
            }
        }
    }

    private boolean valueToBoolean(String value) {
        return value.equalsIgnoreCase("true") || "1".equals(value);
    }

    public static int valueToInt(String value) {
        if (value.startsWith("0x")) {
            return Integer.parseInt(value.substring(2), 16);
        }
        return Integer.parseInt(value);
    }

    public static long valueToLong(String value) {
        if (value.startsWith("0x")) {
            return Long.parseLong(value.substring(2), 16);
        }
        return Long.parseLong(value);
    }

    public EmulatorConfiguration clone(long localAddress) {
        String namePrefix = RemoteDeviceHelper.getBluetoothAddress(localAddress) + ".";
        EmulatorConfiguration deviceConfig = new EmulatorConfiguration();
        for (Map.Entry<String, String> me : this.propertiesMap.entrySet()) {
            String key = me.getKey();
            String value = me.getValue();
            deviceConfig.propertiesMap.put(key, value);
            if (!key.startsWith(namePrefix)) continue;
            deviceConfig.propertiesMap.put(key.substring(namePrefix.length()), value);
        }
        deviceConfig.copyPertiesToFields();
        return deviceConfig;
    }

    public int getDurationLIAC() {
        return this.durationLIAC;
    }

    public int getDeviceInquiryDuration() {
        return this.deviceInquiryDuration;
    }

    public boolean isDeviceInquiryRandomDelay() {
        return this.deviceInquiryRandomDelay;
    }

    public long getFirstDeviceAddress() {
        return this.firstDeviceAddress;
    }

    public String getProperty(long address, String property) {
        String addressString = RemoteDeviceHelper.getBluetoothAddress(address);
        String v = this.getProperty(addressString + "." + property);
        if (v != null) {
            return v;
        }
        return this.getProperty(property);
    }

    public String getProperty(String property) {
        return this.propertiesMap.get(property);
    }

    public int getIntProperty(String property) {
        return Integer.valueOf(this.getProperty(property));
    }

    public String getDeviceNamePrefix() {
        return this.deviceNamePrefix;
    }

    public boolean isDeviceDiscoverable() {
        return this.deviceDiscoverable;
    }

    public int getConnectionBufferSize() {
        return this.connectionBufferSize;
    }

    public boolean isLinkEncryptionSupported() {
        return this.linkEncryptionSupported;
    }

    public int getKeepAliveSeconds() {
        return this.keepAliveSeconds;
    }

    public boolean isSenderFlushBlock() {
        return this.senderFlushBlock;
    }
}

