/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.emu;

import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.RemoteDeviceHelper;
import com.intel.bluetooth.emu.ServicesDescriptor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class DeviceSDP {
    private long address;
    private Hashtable<Long, ServicesDescriptor> services = new Hashtable();

    DeviceSDP(long address) {
        this.address = address;
    }

    synchronized void updateServiceRecord(long handle, ServicesDescriptor sdpData) {
        Long key = new Long(handle);
        boolean update = this.services.get(key) != null;
        this.services.put(key, sdpData);
        String[] serviceUuidSet = sdpData.getUuidSet();
        for (int i = 0; i < serviceUuidSet.length; ++i) {
            DebugLog.debug((update ? "Update" : "Create") + " Srv on " + RemoteDeviceHelper.getBluetoothAddress(this.address) + " " + handle + " " + i + " " + serviceUuidSet[i]);
        }
    }

    synchronized void removeServiceRecord(long handle) {
        ServicesDescriptor srv = this.services.remove(new Long(handle));
        if (srv != null) {
            DebugLog.debug("Remove Srv on " + RemoteDeviceHelper.getBluetoothAddress(this.address) + " " + handle);
        }
    }

    ServicesDescriptor getServicesDescriptor(long handle) {
        return this.services.get(new Long(handle));
    }

    synchronized long[] searchServices(String[] uuidSet) {
        Vector<Long> handles = new Vector<Long>();
        Enumeration<Long> iterator = this.services.keys();
        while (iterator.hasMoreElements()) {
            Long key = iterator.nextElement();
            ServicesDescriptor service = this.services.get(key);
            String[] serviceUuidSet = service.getUuidSet();
            int match = 0;
            block1: for (int i = 0; i < serviceUuidSet.length; ++i) {
                for (int k = 0; k < uuidSet.length; ++k) {
                    if (!uuidSet[k].equals(serviceUuidSet[i])) continue;
                    ++match;
                    continue block1;
                }
            }
            if (match != uuidSet.length) continue;
            handles.addElement(key);
        }
        long[] h = new long[handles.size()];
        int i = 0;
        Enumeration e = handles.elements();
        while (e.hasMoreElements()) {
            h[i++] = ((Long)e.nextElement()).intValue();
        }
        return h;
    }
}

