/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.emu;

import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.RemoteDeviceHelper;
import com.intel.bluetooth.emu.ConnectionBuffer;
import com.intel.bluetooth.emu.ConnectionBufferL2CAP;
import com.intel.bluetooth.emu.ConnectionBufferRFCOMM;
import com.intel.bluetooth.emu.Device;
import com.intel.bluetooth.emu.DeviceCommand;
import com.intel.bluetooth.emu.DeviceDescriptor;
import com.intel.bluetooth.emu.DeviceManagerService;
import com.intel.bluetooth.emu.DeviceSDP;
import com.intel.bluetooth.emu.EmulatorConfiguration;
import com.intel.bluetooth.emu.EmulatorUtils;
import com.intel.bluetooth.emu.MonitorDevice;
import com.intel.bluetooth.emu.ServiceListener;
import com.intel.bluetooth.emu.ServicesDescriptor;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.bluetooth.BluetoothConnectionException;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.ServiceRegistrationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceManagerServiceImpl
implements DeviceManagerService {
    public static final int MAJOR_COMPUTER = 256;
    static final EmulatorConfiguration configuration;
    private static Map<Long, Device> devices;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Map<Long, Device> map = devices;
        synchronized (map) {
            for (Device device : devices.values()) {
                device.release();
            }
            devices.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceDescriptor createNewDevice(String deviceID, String deviceAddress) throws BluetoothStateException {
        Map<Long, Device> map = devices;
        synchronized (map) {
            long address = this.getNextAvailableBTAddress(deviceID, deviceAddress);
            String name = configuration.getProperty(address, "deviceName");
            if (name == null) {
                name = configuration.getDeviceNamePrefix() + RemoteDeviceHelper.getBluetoothAddress(address);
            }
            int deviceClass = 256;
            String cod = configuration.getProperty(address, "deviceClass");
            if (cod != null) {
                deviceClass = EmulatorConfiguration.valueToInt(cod);
            }
            DeviceDescriptor descriptor = new DeviceDescriptor(address, name, deviceClass);
            if (!configuration.isDeviceDiscoverable()) {
                descriptor.setDiscoverableMode(0);
            }
            devices.put(new Long(address), new Device(descriptor));
            return descriptor;
        }
    }

    @Override
    public EmulatorConfiguration getEmulatorConfiguration(long localAddress) {
        return configuration.clone(localAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseDevice(long address) {
        Device device;
        Map<Long, Device> map = devices;
        synchronized (map) {
            device = devices.remove(new Long(address));
        }
        if (device != null) {
            device.release();
        }
    }

    @Override
    public DeviceCommand pollCommand(long address) {
        Device device = DeviceManagerServiceImpl.getDevice(address);
        if (device == null) {
            throw new RuntimeException("No such device " + RemoteDeviceHelper.getBluetoothAddress(address));
        }
        return device.pollCommand();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Device getDevice(long address) {
        Device d = devices.get(new Long(address));
        if (d != null && !d.isAlive()) {
            Map<Long, Device> map = devices;
            synchronized (map) {
                devices.remove(new Long(address));
            }
            d.died();
            return null;
        }
        return d;
    }

    private Device getActiveDevice(long address) {
        Device d = DeviceManagerServiceImpl.getDevice(address);
        if (d != null && !d.getDescriptor().isPoweredOn()) {
            return null;
        }
        return d;
    }

    @Override
    public DeviceDescriptor getDeviceDescriptor(long address) {
        Device device = DeviceManagerServiceImpl.getDevice(address);
        if (device == null) {
            throw new RuntimeException("No such device " + RemoteDeviceHelper.getBluetoothAddress(address));
        }
        return device.getDescriptor();
    }

    private DeviceSDP getDeviceSDP(long address) {
        Device device = this.getActiveDevice(address);
        if (device == null) {
            return null;
        }
        return device.getDeviceSDP(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<MonitorDevice> getMonitorDevices() {
        Vector<MonitorDevice> monitorDevices = new Vector<MonitorDevice>();
        Map<Long, Device> map = devices;
        synchronized (map) {
            Iterator<Device> iterator = devices.values().iterator();
            while (iterator.hasNext()) {
                Device device = iterator.next();
                if (!device.isAlive()) {
                    iterator.remove();
                    device.died();
                    continue;
                }
                DeviceManagerServiceImpl.isDiscoverable(device.getDescriptor());
                monitorDevices.add(new MonitorDevice(device));
            }
        }
        return monitorDevices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceDescriptor[] getDiscoveredDevices(long address) {
        Vector<DeviceDescriptor> discoveredDevice = new Vector<DeviceDescriptor>();
        Map<Long, Device> map = devices;
        synchronized (map) {
            Iterator<Device> iterator = devices.values().iterator();
            while (iterator.hasNext()) {
                Device device = iterator.next();
                if (!device.isAlive()) {
                    iterator.remove();
                    device.died();
                    continue;
                }
                if (device.getDescriptor().getAddress() == address || !DeviceManagerServiceImpl.isDiscoverable(device.getDescriptor())) continue;
                discoveredDevice.addElement(device.getDescriptor());
            }
        }
        return discoveredDevice.toArray(new DeviceDescriptor[discoveredDevice.size()]);
    }

    private static boolean isDiscoverable(DeviceDescriptor device) {
        if (!device.isPoweredOn()) {
            return false;
        }
        int discoverableMode = device.getDiscoverableMode();
        switch (discoverableMode) {
            case 0: {
                return false;
            }
            case 10390323: {
                return true;
            }
            case 10390272: {
                if (device.getLimitedDiscoverableStart() + (long)(configuration.getDurationLIAC() * 1000 * 60) < System.currentTimeMillis()) {
                    DebugLog.debug(RemoteDeviceHelper.getBluetoothAddress(device.getAddress()) + " LIAC -> NOT_DISCOVERABLE");
                    device.setDiscoverableMode(0);
                    return false;
                }
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean isLocalDevicePowerOn(long localAddress) {
        return this.getDeviceDescriptor(localAddress).isPoweredOn();
    }

    @Override
    public void setLocalDevicePower(long localAddress, boolean on) {
        Device device = DeviceManagerServiceImpl.getDevice(localAddress);
        if (device == null) {
            throw new RuntimeException("No such device " + RemoteDeviceHelper.getBluetoothAddress(localAddress));
        }
        device.setDevicePower(on);
    }

    @Override
    public int getLocalDeviceDiscoverable(long localAddress) {
        DeviceDescriptor dd = this.getDeviceDescriptor(localAddress);
        if (!dd.isPoweredOn()) {
            return 0;
        }
        DeviceManagerServiceImpl.isDiscoverable(dd);
        return dd.getDiscoverableMode();
    }

    @Override
    public boolean setLocalDeviceDiscoverable(long localAddress, int mode) throws BluetoothStateException {
        DeviceDescriptor dd = this.getDeviceDescriptor(localAddress);
        if (!dd.isPoweredOn()) {
            throw new BluetoothStateException("Device power is off");
        }
        DebugLog.debug(RemoteDeviceHelper.getBluetoothAddress(localAddress) + " setDiscoverableMode", EmulatorUtils.discoverableModeString(mode));
        dd.setDiscoverableMode(mode);
        return true;
    }

    @Override
    public void setLocalDeviceServiceClasses(long localAddress, int classOfDevice) {
        DebugLog.debug(RemoteDeviceHelper.getBluetoothAddress(localAddress) + " setServiceClasses ", classOfDevice);
        this.getDeviceDescriptor(localAddress).setDeviceClass(classOfDevice);
    }

    @Override
    public String getRemoteDeviceFriendlyName(long address) throws IOException {
        DeviceDescriptor dd = this.getDeviceDescriptor(address);
        if (!dd.isPoweredOn()) {
            throw new IOException("Remote device power is off");
        }
        return dd.getName();
    }

    private long getNextAvailableBTAddress(String deviceID, String deviceAddress) throws BluetoothStateException {
        if (deviceID != null) {
            long id = configuration.getFirstDeviceAddress() + Long.parseLong(deviceID);
            if (DeviceManagerServiceImpl.getDevice(id) != null) {
                throw new BluetoothStateException("Device already reserved " + RemoteDeviceHelper.getBluetoothAddress(id));
            }
            return id;
        }
        if (deviceAddress != null) {
            long address = RemoteDeviceHelper.getAddress(deviceAddress);
            if (DeviceManagerServiceImpl.getDevice(address) != null) {
                throw new BluetoothStateException("Device already reserved " + RemoteDeviceHelper.getBluetoothAddress(address));
            }
            return address;
        }
        return EmulatorUtils.getNextAvailable(devices.keySet(), configuration.getFirstDeviceAddress(), 1);
    }

    @Override
    public void updateServiceRecord(long address, long handle, ServicesDescriptor sdpData) throws ServiceRegistrationException {
        Device device = this.getActiveDevice(address);
        if (device == null) {
            throw new ServiceRegistrationException("No such device " + RemoteDeviceHelper.getBluetoothAddress(address));
        }
        DeviceSDP ds = device.getDeviceSDP(true);
        ds.updateServiceRecord(handle, sdpData);
    }

    @Override
    public void removeServiceRecord(long address, long handle) throws IOException {
        DeviceSDP ds = this.getDeviceSDP(address);
        if (ds != null) {
            ds.removeServiceRecord(handle);
        }
    }

    @Override
    public long[] searchServices(long address, String[] uuidSet) {
        if (this.getActiveDevice(address) == null) {
            return null;
        }
        DeviceSDP ds = this.getDeviceSDP(address);
        if (ds == null) {
            return new long[0];
        }
        return ds.searchServices(uuidSet);
    }

    @Override
    public byte[] getServicesRecordBinary(long address, long handle) throws IOException {
        DeviceSDP ds = this.getDeviceSDP(address);
        if (ds == null) {
            throw new IOException("No such device " + RemoteDeviceHelper.getBluetoothAddress(address));
        }
        ServicesDescriptor sd = ds.getServicesDescriptor(handle);
        if (sd == null) {
            throw new IOException("No such service");
        }
        return sd.getSdpBinary();
    }

    @Override
    public void rfOpenService(long localAddress, int channel) throws IOException {
        this.openService(localAddress, ServiceListener.rfPrefix(channel));
    }

    @Override
    public long rfAccept(long localAddress, int channel, boolean authenticate, boolean encrypt) throws IOException {
        return this.accept(localAddress, ServiceListener.rfPrefix(channel), authenticate, encrypt, 0);
    }

    @Override
    public long rfConnect(long localAddress, long remoteAddress, int channel, boolean authenticate, boolean encrypt, int timeout) throws IOException {
        return this.connect(localAddress, remoteAddress, ServiceListener.rfPrefix(channel), authenticate, encrypt, 0, timeout);
    }

    @Override
    public void rfCloseService(long address, int pcm) {
        this.closeService(address, ServiceListener.rfPrefix(pcm));
    }

    @Override
    public void l2OpenService(long localAddress, int pcm) throws IOException {
        this.openService(localAddress, ServiceListener.l2Prefix(pcm));
    }

    @Override
    public long l2Accept(long localAddress, int channel, boolean authenticate, boolean encrypt, int receiveMTU) throws IOException {
        return this.accept(localAddress, ServiceListener.l2Prefix(channel), authenticate, encrypt, receiveMTU);
    }

    @Override
    public long l2Connect(long localAddress, long remoteAddress, int channel, boolean authenticate, boolean encrypt, int receiveMTU, int timeout) throws IOException {
        return this.connect(localAddress, remoteAddress, ServiceListener.l2Prefix(channel), authenticate, encrypt, receiveMTU, timeout);
    }

    @Override
    public void l2CloseService(long address, int channel) {
        this.closeService(address, ServiceListener.l2Prefix(channel));
    }

    private long accept(long localAddress, String channelID, boolean authenticate, boolean encrypt, int receiveMTU) throws IOException {
        Device device = this.getActiveDevice(localAddress);
        if (device == null) {
            throw new IOException("No such device " + RemoteDeviceHelper.getBluetoothAddress(localAddress));
        }
        ServiceListener sl = device.createServiceListener(channelID);
        return sl.accept(device, authenticate, encrypt, receiveMTU);
    }

    private long connect(long localAddress, long remoteAddress, String portID, boolean authenticate, boolean encrypt, int receiveMTU, int timeout) throws IOException {
        Device remoteDevice = this.getActiveDevice(remoteAddress);
        if (remoteDevice == null) {
            throw new BluetoothConnectionException(4, "No such device " + RemoteDeviceHelper.getBluetoothAddress(remoteAddress));
        }
        Device localDevice = this.getActiveDevice(localAddress);
        if (localDevice == null) {
            throw new BluetoothConnectionException(4, "No such device " + RemoteDeviceHelper.getBluetoothAddress(localAddress));
        }
        if (localDevice.getConnectionBuffer(remoteAddress, portID) != null) {
            throw new BluetoothConnectionException(4, "Already connected to the same port " + portID + " on " + RemoteDeviceHelper.getBluetoothAddress(remoteAddress));
        }
        ServiceListener sl = remoteDevice.connectService(portID, timeout);
        if (sl == null) {
            throw new BluetoothConnectionException(1, "No such service " + portID);
        }
        return sl.connect(localDevice, authenticate, encrypt, receiveMTU, timeout);
    }

    @Override
    public void connectionAccepted(long localAddress, long connectionId) throws IOException {
        Device device = this.getActiveDevice(localAddress);
        if (device == null) {
            throw new IOException("No such device " + RemoteDeviceHelper.getBluetoothAddress(localAddress));
        }
        ConnectionBuffer c = device.getConnectionBuffer(connectionId);
        if (c == null) {
            throw new IOException("No such connection " + connectionId);
        }
        c.accepted();
    }

    private void openService(long address, String channelID) throws IOException {
        Device device = this.getActiveDevice(address);
        if (device == null) {
            throw new IOException("No such device " + RemoteDeviceHelper.getBluetoothAddress(address));
        }
        device.openService(channelID);
    }

    private void closeService(long address, String channelID) {
        Device device = DeviceManagerServiceImpl.getDevice(address);
        if (device == null) {
            return;
        }
        device.closeService(channelID);
    }

    private ConnectionBuffer getConnectionBuffer(long localAddress, long connectionId) throws IOException {
        Device localDevice = this.getActiveDevice(localAddress);
        if (localDevice == null) {
            throw new IOException("No such device " + RemoteDeviceHelper.getBluetoothAddress(localAddress));
        }
        ConnectionBuffer c = localDevice.getConnectionBuffer(connectionId);
        if (c == null) {
            throw new IOException("No such connection " + connectionId);
        }
        return c;
    }

    @Override
    public long getRemoteAddress(long localAddress, long connectionId) throws IOException {
        return this.getConnectionBuffer(localAddress, connectionId).getRemoteAddress();
    }

    @Override
    public void rfWrite(long localAddress, long connectionId, byte[] b) throws IOException {
        ((ConnectionBufferRFCOMM)this.getConnectionBuffer(localAddress, connectionId)).rfWrite(b);
    }

    @Override
    public void rfFlush(long localAddress, long connectionId) throws IOException {
        ((ConnectionBufferRFCOMM)this.getConnectionBuffer(localAddress, connectionId)).rfFlush();
    }

    @Override
    public int rfAvailable(long localAddress, long connectionId) throws IOException {
        return ((ConnectionBufferRFCOMM)this.getConnectionBuffer(localAddress, connectionId)).rfAvailable();
    }

    @Override
    public byte[] rfRead(long localAddress, long connectionId, int len) throws IOException {
        return ((ConnectionBufferRFCOMM)this.getConnectionBuffer(localAddress, connectionId)).rfRead(len);
    }

    @Override
    public void closeConnection(long localAddress, long connectionId) throws IOException {
        Device localDevice = DeviceManagerServiceImpl.getDevice(localAddress);
        if (localDevice == null) {
            throw new IOException("No such device " + RemoteDeviceHelper.getBluetoothAddress(localAddress));
        }
        localDevice.closeConnection(connectionId);
    }

    @Override
    public int getSecurityOpt(long localAddress, long connectionId, int expected) throws IOException {
        return this.getConnectionBuffer(localAddress, connectionId).getSecurityOpt(expected);
    }

    @Override
    public boolean encrypt(long localAddress, long connectionId, long remoteAddress, boolean on) throws IOException {
        return this.getConnectionBuffer(localAddress, connectionId).encrypt(remoteAddress, on);
    }

    @Override
    public int l2RemoteDeviceReceiveMTU(long localAddress, long connectionId) throws IOException {
        return ((ConnectionBufferL2CAP)this.getConnectionBuffer(localAddress, connectionId)).getRemoteReceiveMTU();
    }

    @Override
    public boolean l2Ready(long localAddress, long connectionId) throws IOException {
        return ((ConnectionBufferL2CAP)this.getConnectionBuffer(localAddress, connectionId)).ready();
    }

    @Override
    public byte[] l2Receive(long localAddress, long connectionId, int len) throws IOException {
        return ((ConnectionBufferL2CAP)this.getConnectionBuffer(localAddress, connectionId)).receive(len);
    }

    @Override
    public void l2Send(long localAddress, long connectionId, byte[] data) throws IOException {
        ((ConnectionBufferL2CAP)this.getConnectionBuffer(localAddress, connectionId)).send(data);
    }

    static {
        devices = new Hashtable<Long, Device>();
        configuration = new EmulatorConfiguration();
        configuration.loadConfigFile();
    }
}

