/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BlueCoveImpl;
import com.intel.bluetooth.EmulatorHelper;
import com.intel.bluetooth.UtilsJavaSE;
import javax.bluetooth.BluetoothStateException;

public class EmulatorTestsHelper {
    private static int threadNumber;

    private static synchronized int nextThreadNum() {
        return threadNumber++;
    }

    public static void startInProcessServer() {
        BlueCoveImpl.setConfigProperty("bluecove.emu.rmiRegistryPort", "0");
    }

    public static void stopInProcessServer() {
        BlueCoveImpl.shutdown();
        EmulatorHelper.getService().shutdown();
    }

    public static void useThreadLocalEmulator() throws BluetoothStateException {
        EmulatorTestsHelper.useThreadLocalEmulator(null, null);
    }

    public static void useThreadLocalEmulator(String deviceID, String localAddress) throws BluetoothStateException {
        BlueCoveImpl.useThreadLocalBluetoothStack();
        BlueCoveImpl.setConfigProperty("bluecove.stack", "emulator");
        BlueCoveImpl.setConfigProperty("bluecove.emu.rmiRegistryPort", "0");
        BlueCoveImpl.setConfigProperty("bluecove.deviceID", deviceID);
        BlueCoveImpl.setConfigProperty("bluecove.deviceAddress", localAddress);
        BlueCoveImpl.getThreadBluetoothStackID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Thread runNewEmulatorStack(Runnable runnable) throws BluetoothStateException {
        RunBefore r = new RunBefore(runnable);
        int id = EmulatorTestsHelper.nextThreadNum();
        ThreadGroup g = new ThreadGroup("TestHelperThreadGroup-" + id);
        Thread t = new Thread(g, r, "TestHelperThread-" + id);
        Object object = r.startedEvent;
        synchronized (object) {
            t.start();
            while (!r.started) {
                try {
                    r.startedEvent.wait();
                }
                catch (InterruptedException e) {
                    throw (BluetoothStateException)UtilsJavaSE.initCause(new BluetoothStateException(e.getMessage()), e);
                }
                if (r.startException == null) continue;
                throw r.startException;
            }
        }
        return t;
    }

    private static class RunBefore
    implements Runnable {
        private Runnable runnable;
        private Object startedEvent = new Object();
        private boolean started = false;
        private BluetoothStateException startException;

        RunBefore(Runnable runnable) {
            this.runnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                EmulatorTestsHelper.useThreadLocalEmulator();
            }
            catch (BluetoothStateException e) {
                this.startException = e;
            }
            finally {
                this.started = true;
                Object object = this.startedEvent;
                synchronized (object) {
                    this.startedEvent.notifyAll();
                }
            }
            this.runnable.run();
        }
    }
}

